import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [schedules] = await db.query('SELECT * FROM schedules WHERE id = ?', [id]);
    
    if (schedules.length === 0) {
      return json({ error: 'Jadwal tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: schedules[0] });
  } catch (error) {
    console.error('Get schedule error:', error);
    return json({ error: 'Gagal mengambil data jadwal' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { class: className, day, time, subject, teacher, room, year, semester } = data;

    if (!className || !day || !time || !subject || !teacher) {
      return json({ error: 'Kelas, Hari, Waktu, Mata Pelajaran, dan Guru wajib diisi' }, { status: 400 });
    }

    await db.query(
      `UPDATE schedules 
       SET class = ?, day = ?, time = ?, subject = ?, teacher = ?, room = ?, year = ?, semester = ?
       WHERE id = ?`,
      [className.trim(), day.trim(), time.trim(), subject.trim(), teacher.trim(), room || null, year || null, semester || null, id]
    );

    return json({ success: true, message: 'Jadwal berhasil diupdate' });
  } catch (error) {
    console.error('Update schedule error:', error);
    return json({ error: 'Gagal mengupdate jadwal' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM schedules WHERE id = ?', [id]);
    return json({ success: true, message: 'Jadwal berhasil dihapus' });
  } catch (error) {
    console.error('Delete schedule error:', error);
    return json({ error: 'Gagal menghapus jadwal' }, { status: 500 });
  }
}
